<?php
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = trim($_POST['id']);
    $name = trim($_POST['name']);
    $mobile = trim($_POST['mobile']);
    $email = trim($_POST['email']);

    // Validate inputs
    if (empty($id) || empty($name) || empty($mobile) || strlen($mobile) !== 10 || !is_numeric($mobile)) {
        echo json_encode(["error" => "Invalid input. Please check the form fields."]);
        exit;
    }

    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        die(json_encode(["error" => "Database connection failed: " . $conn->connect_error]));
    }

    // Check if mobile number already exists for another record
    $checkStmt = $conn->prepare("SELECT id FROM records WHERE mobile = ? AND id != ?");
    $checkStmt->bind_param("si", $mobile, $id);
    $checkStmt->execute();
    $checkResult = $checkStmt->get_result();

    if ($checkResult->num_rows > 0) {
        echo json_encode(["error" => "Mobile number already exists for another customer."]);
        $checkStmt->close();
        $conn->close();
        exit;
    }
    $checkStmt->close();

    // Update the record
    $stmt = $conn->prepare("UPDATE records SET name = ?, mobile = ?, email = ? WHERE id = ?");
    $stmt->bind_param("sssi", $name, $mobile, $email, $id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(["success" => "Record updated successfully."]);
        } else {
            echo json_encode(["error" => "No record found with the given ID or no changes made."]);
        }
    } else {
        echo json_encode(["error" => "Error updating record: " . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["error" => "Invalid request method."]);
}
?>
