<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'config.php';

// Log the incoming request
error_log("addRecord.php called with method: " . $_SERVER['REQUEST_METHOD']);
error_log("POST data: " . print_r($_POST, true));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $mobile = trim($_POST['mobile'] ?? '');
    $email = trim($_POST['email'] ?? '');
    // Enhanced validation
    $errors = [];
    if (empty($name)) {
        $errors[] = "Name is required";
    }
    if (empty($mobile)) {
        $errors[] = "Mobile number is required";
    } elseif (strlen($mobile) !== 10 || !is_numeric($mobile)) {
        $errors[] = "Mobile number must be exactly 10 digits";
    }
    if (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email format";
    }
    if (!empty($errors)) {
        echo json_encode(["error" => implode(", ", $errors)]);
        exit;
    }
    try {
        $conn = new mysqli($servername, $username, $password, $dbname);
        if ($conn->connect_error) {
            throw new Exception("Database connection failed: " . $conn->connect_error);
        }
        // Check if mobile number already exists
        $checkStmt = $conn->prepare("SELECT id FROM records WHERE mobile = ?");
        if (!$checkStmt) {
            throw new Exception("Prepare statement failed: " . $conn->error);
        }
        $checkStmt->bind_param("s", $mobile);
        $checkStmt->execute();
        $checkResult = $checkStmt->get_result();
        if ($checkResult->num_rows > 0) {
            echo json_encode(["error" => "Mobile number already exists. Please use a different mobile number."]);
            $checkStmt->close();
            $conn->close();
            exit;
        }
        $checkStmt->close();
        // Generate policy number
        $policyNumber = 'AX-' . date('Y') . '-' . rand(1000, 9999) . '-' . rand(1000, 9999);
        // Insert new record (without policy_type)
        $stmt = $conn->prepare("INSERT INTO records (name, mobile, email, policy_number, created_at) VALUES (?, ?, ?, ?, NOW())");
        if (!$stmt) {
            throw new Exception("Prepare statement failed: " . $conn->error);
        }
        $stmt->bind_param("ssss", $name, $mobile, $email, $policyNumber);
        if ($stmt->execute()) {
            echo json_encode([
                "success" => true,
                "message" => "Customer record added successfully",
                "policy_number" => $policyNumber,
                "id" => $conn->insert_id
            ]);
        } else {
            throw new Exception("Error executing statement: " . $stmt->error);
        }
        $stmt->close();
        $conn->close();
    } catch (Exception $e) {
        error_log("Error in addRecord.php: " . $e->getMessage());
        echo json_encode(["error" => "Database error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["error" => "Invalid request method. Expected POST."]);
}
?>